var landingPage   = document.getElementById('landing-page');
var regTypeWrapper= landingPage.querySelector(".regtype-wrapper");
var regType       = landingPage.querySelector('#reg-type');
var check_TC      = landingPage.querySelector('#terms-check'); 
var procceedBtn   = landingPage.querySelector('#procceed-btn'); 


var stepsWrapper  = document.getElementById('setup-wrapper');
var stepWrappers  = stepsWrapper.querySelectorAll('.step-wrapper');
var fielLoader_PI = stepsWrapper.querySelector('#pesonal-info #field-loader');
var fielLoader_AC = stepsWrapper.querySelector('#account-gstin #field-loader');
var fielLoader_DU = stepsWrapper.querySelector('#document-info #field-loader');

var regForm = document.getElementById('registeration-form')



// Field Templates
var pi_individual = document.getElementById('personal-info-individual');
var pi_firm       = document.getElementById('personal-info-firm');
var ac_individual = document.getElementById('account-gstin-individual');
var ac_firm       = document.getElementById('account-gstin-firm');
var du_individual = document.getElementById('final-information-individual');
var du_firm       = document.getElementById('final-information-firm');


// Manage Commodity Instance
var manageComInstance;

// Manage Fields Verification instance
var manageverifications;

var regRawData = [];


functionInitializer(()=>{
    setupWizard()
    fadeOut(regTypeWrapper,stepsWrapper);

    addFormValidations('registeration-form',registeration)
    

    // testMode()
    $.getJSON('./json/registeration.json',(json)=>{
      regRawData = json;
      console.log(regRawData);
    })

    $(".back-btn").click(()=>{
      fadeOut(stepsWrapper);
      fadeIn(landingPage);
    })

  
})

function sendReq(url,data) { 
    appLoader.style.display = 'flex';
    return new Promise(resolve=>{
        let reqData = data;
        $.ajax({
            type: "POST",
            url: "http://devservr.sparsht.com:8080/usermanage/api/register",
            data: reqData,
            enctype: 'multipart/form-data',
            processData: false,
            contentType:false,
            timeout: 600000,
            success: function (response) {
                valResponse(response)
                resolve(response)
                appLoader.style.display = 'none'
            },
            error: function(response){
                valResponse(response)
                resolve(response)
            }
        });
    })
}

/**Step Wizard */
  function setupWizard(){
      var idx = 0 ;
      function setClasses(index, steps) {
        idx = index;
          stepChanger(stepWrappers[index]);
          if (index < 0 || index > steps) return;
          if(index == 0) {
            if($("#prev").text() === 'Back'){
              return;
            }
            $("#prev").text('Back');
          } 
          if(index == steps) {
            $("#next").text('Submit');
          } else {
            $("#next").text('Next');
          }

          $("ul li").each(function() {
            $(this).removeClass();
          });

          $("ul li:lt(" + index + ")").each(function() {
            $(this).addClass("done");
          });

          $("ul li:eq(" + index + ")").addClass("active")

          var p = index * (100 / steps);
          $("#prog").width(p + '%');
        }
        
        $("#prev").click(function(){
            if($("#prev").text() === 'Back'){
              fadeOut(stepsWrapper)
              fadeIn(landingPage)
              return;
            }
            var step = $(".step-wizard ul li.active div.step")[0].innerText;
            var steps = $(".step-wizard ul li").length;    
            setClasses(step - 2, steps - 1);
          
        });

        $("#next").click(function(){
          if ($(this).text() == 'Submit') {
            $("#submit")[0].click()
          } else {
            
            
            if($("#prev").text() === 'Back'){
              $("#prev").text('Previus');
            }
            var step = $(".step-wizard ul li.active div.step")[0].innerText;
            var steps = $(".step-wizard ul li").length;    
            setClasses(step, steps - 1);  

          }
        });
        
        // initial state setup
        setClasses(0, $(".step-wizard ul li").length);
        stepChanger(stepWrappers[0]);
  }
      
  function stepChanger(stepname){
    stepWrappers.forEach(wrapper=> wrapper.style.display ='none' );
    fadeIn(stepname)
  }

  function resetWizard(){

    document.querySelectorAll(".step-wizard ul li").forEach(li=> li.className = '' );
    document.querySelector(".step-wizard ul li").className = 'active';
    stepsWrapper.querySelectorAll("input").forEach(input=> input.value = '');
    stepsWrapper.querySelectorAll("select").forEach(input=> input.value = '');

    $("#next").text("Next");

    setupWizard()
  }

  function documentValidatore() {
    var validate = true;
    var docWrapper = stepsWrapper.querySelector('#document-info');
    // Text Inputs
    var gstInput = stepsWrapper.querySelector('#gstinno');
    var f27eInput = stepsWrapper.querySelector('#f27Celigible');

    var requiredDocs = docWrapper.querySelectorAll('.required');


    requiredDocs.forEach(input=>{
      if(input.files.length === 0){
        input.style.border = '1px solid red';
        Toaster('error','Missing Documents',"Please Upload Required Documents !");
        validate = false;
      }

      input.addEventListener('change',event=> {
        if(event.target.files.length === 0){
          event.target.style.border = '1px solid red'
        }else{
          event.target.style.border = '1px solid green'
        }
      });

    })
    

    // Doc Inputs
    var gstDoc = stepsWrapper.querySelector('#gst_proof');
    var f27eDoc = stepsWrapper.querySelector('#f27c_doc');

    if(gstInput.value !== '' && gstDoc.files.length === 0){
      gstDoc.style.border = '1px solid red';
      validate = false;
      Toaster('error','Document Not Available',"Please Upload GSTIN Document !");
      return;
    }else if(gstDoc.files.length !== 0 && gstInput.value === ''){
      gstInput.style.border = '1px solid red';
      gstDoc.style.border = '1px solid green';
      validate = false;
      Toaster('error','GSTIN Missing',"Please Enter GSTIN Number As Per Your Document");
      return;
      
    }

    gstDoc.addEventListener('change',(event)=>{
      console.log(event);
      if(gstDoc.files.length !== 0) {
        gstDoc.style.border = '1px solid green';
      }else if(gstDoc.files.length === 0 && gstInput.value === ''){
        gstDoc.style.border = '1px solid #ced4da'; 
      }else if(gstDoc.files.length === 0 && gstInput.value !== ''){
        gstDoc.style.border = '1px solid red';
      }

    })

    if(f27eInput){
      if(f27eInput.value === 'Y' && f27eDoc.files.length === 0){
        f27eDoc.style.border = '1px solid red';
        validate = false;
        Toaster('error','Document Not Available',"Please Upload 27C Eligibility Document !");
        return;
      }else if(f27eInput.value === 'Y' && f27eDoc.files.length !== 0){
        f27eDoc.style.border = '1px solid green';
      }else if(f27eInput.value === 'N' && f27eDoc.files.length === 0){
        f27eDoc.style.border = '1px solid #ced4da';
      }

    }
    
    return validate;

  }

/**End Step Wizard */


// Verification


// End Verification

async function registeration(event){
    var formdata = new FormData(regForm);
    var intrestedAreas = document.querySelectorAll(".fstControls .fstChoiceItem");
  
    formdata.append('act','reg');

    if(regType.value === 'I'){
      formdata.append('pr.nm',formdata.get("pr.fnm")+" "+ formdata.get("pr.lnm").trim());
      formdata.append('f27c','-');
    }

    if(regType.value === 'F') formdata.append('dob','-');
    
    formdata.append('pr.typ',regType.value);

    var comdty = manageComInstance.getSelectedCommodities("idString",true);
    if(comdty.length == 0) return;

    formdata.append('comdty',manageComInstance.getSelectedCommodities("idString",true))
    
    if(fieldValidatore()){
      sendReq('prreg',formdata)
    }else{
      return;
    }
    
        
}

function fieldValidatore(stepname){
  var validate = true;

  // Personal info
  // var phoneVerify = document.querySelector('#registeration-form #verify-phone');
  // var emailVerify = document.querySelector('#registeration-form #verify-email');

  // if(phoneVerify.value !== "true"){
  //   Toaster('error','Mobile Not Verified !','Please Verify Your Mobile Number !')
  //   return false;
  // }else if(emailVerify.value !== "true"){
  //   Toaster('error','Email Not Verified !','Please Verify Your Email Number !')
  //   return false;
  // }else{
  //   return true
  // }

  return validate;
}

function fieldLoader(regtype){

  if(regtype === 'I'){

    fielLoader_PI.innerHTML = '';
    fielLoader_AC.innerHTML = '';
    fielLoader_DU.innerHTML = '';
    fielLoader_PI.append(document.importNode(pi_individual.content,true))
    fielLoader_AC.append(document.importNode(ac_individual.content,true))
    fielLoader_DU.append(document.importNode(du_individual.content,true))

    // console.log(document.getElementById('gstcheck'));

    document.getElementById('gstcheck').addEventListener('change',function () { 
      if(this.checked === false){
        document.querySelector('.gst-input').style.display = 'none';
        document.querySelectorAll('.gst-input input').forEach(input=>input.required = false)
      }else{
        document.querySelector('.gst-input').style.display = 'block';
        document.querySelectorAll('.gst-input input').forEach(input=>input.required = true)
      }
    })

    document.querySelector(".gst-input").style.display = 'none'


  }else{
    fielLoader_PI.innerHTML = '';
    fielLoader_AC.innerHTML = '';
    fielLoader_DU.innerHTML = '';
    fielLoader_PI.append(document.importNode(pi_firm.content,true))
    fielLoader_AC.append(document.importNode(ac_firm.content,true))
    fielLoader_DU.append(document.importNode(du_firm.content,true))
  }

  document.querySelector('.show-password').addEventListener('click',function(){

    if(this.classList.contains('visible')){
      this.previousElementSibling.type = 'text';
      this.innerHTML = '<i class="fa-solid fa-eye-slash"></i>';
      this.classList.remove('visible')
    }else{
      this.innerHTML = '<i class="fa-solid fa-eye"></i>';
      this.previousElementSibling.type = 'password';
      this.classList.add('visible')
    }

  })
  

  document.querySelector('#state').addEventListener('change',(event)=>{
    var selectedOption =  event.target.options[event.target.selectedIndex];
    document.querySelector("#state-value").value = selectedOption.value;
    document.querySelector("#state-text").value = selectedOption.text;
    if(selectedOption.text === 'select'){
      document.querySelector("#state-text").value = '';
    }

  })


  document.querySelectorAll('.file-refresh-icon').forEach(icon=>{
    icon.addEventListener('click',()=>{
      console.log(icon.previousElementSibling);
      icon.previousElementSibling.value = '';
    })
  })

  $(".firm_name").change(()=>{
    alert($(".firm_name").val())
  })

  $("#email").change(event => $("#logid").val(event.target.value) );

  $("#logid").on('input',()=>{
    if($("#logid").val() === $("#email").val()){
      $(".check-avlblty-btn-wrapper").fadeOut()
    }else{
      $(".check-avlblty-btn-wrapper").fadeIn()
    }
  })

  manageComInstance   = new ManageCommodities();
  manageverifications = new ManageVerifications();
  

  rawDataFiller(document.getElementById('state'),'states',regRawData);
  rawDataFiller(document.getElementById('que1_id'),'questions',regRawData);
  rawDataFiller(document.getElementById('que2_id'),'questions',regRawData);

  $("#setup-wrapper input, #setup-wrapper select").change(setFinalInfo)

  $("#setup-wrapper input, #setup-wrapper select").trigger('change');

  if(regType.value === 'F'){
    $("#firm-organization-name").change(()=>$("#holdernm").val($("#firm-organization-name").val()));
  }else{
    $(".authority-first-name").change(()=>$("#holdernm").val($(".authority-first-name")+" "+$(".last-name")));
    $(".last-name").change(()=>$("#holdernm").val($(".authority-first-name").val()+" "+$(".last-name").val()));
    
  }


  new AddedDocsRender()
}

function rawDataFiller(element,keyname,rawArray) { 
  var rawInfo = rawArray.find(info=>info.name === keyname);
  var options = '<option value="">select</option>'
  element.innerHTML = '';
  
  rawInfo.keyValues.forEach(keyvalue=>{
    options +=getOption(keyvalue.key,keyvalue.value);
  })

  element.innerHTML = options;

}

function setFinalInfo(){

  var finalInfo      = new FormData(regForm);
  var finalInfoSpans = $(".final-info-text").toArray(); 

  $(".intrested-commodities").text(manageComInstance.getSelectedCommodities("nameString"))

  for(let key of finalInfo.keys()){
    var current = finalInfoSpans.find(span=>span.dataset.infoTextKey === key);
        if(current){
          current.textContent = finalInfo.get(key);
        }
  }

}

check_TC.addEventListener('change',function() {
    if(this.checked){
      fadeIn(regTypeWrapper)
    }else{
      fadeOut(regTypeWrapper)
      regType.value = 'none';
    }
  
})

regType.addEventListener('change',function() {
    if(this.value !== 'none' && check_TC.checked){
        fadeIn(stepsWrapper)
        fadeOut(landingPage)
        fieldLoader(this.value);
        // $("#area_of_intrest").fastselect()
    }else{
        
    }
  
});
 
function containsSpecialChars(str) {
     const specialChars = /[`!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?~]/;
     return specialChars.test(str);
}


// Manage Commodity
function ManageCommodities(){

  this.allCommodities = [  
    {"CMDT_NME": "Bamboo","CMDTYID":"1"},
    {"CMDT_NME": "Tendu","CMDTYID":"2"},
    {"CMDT_NME": "Firewood","CMDTYID":"3"},
    {"CMDT_NME": "Timber","CMDTYID":"4"}
  ]

  this.mainSetup = () =>{
    this.renderCommodities()
  }

  this.renderCommodities = () =>{
    this.allCommodities.forEach((comdata)=>{
        $("#load-commodities").append($(`
          <div class="col-lg-3 col-4">
            <div class="form-check mb-2">
                <input class="form-check-input commodity-check" type="checkbox" value="${comdata.CMDT_NME}" data-comid="${comdata.CMDTYID}" id="comdtyid${comdata.CMDTYID}">
                <label class="form-check-label" for="comdtyid${comdata.CMDTYID}">
                  ${comdata.CMDT_NME}
                </label>
            </div>
          </div>
        `))
    })
  }

  this.getSelectedCommodities = (strignType,throwError) =>{
    var checkedFields = $(".commodity-check").toArray().filter( input => input.checked=== true);

    if(checkedFields.length == 0){
      if(throwError) Toaster('error','Missing interested commodities !',"Please check commodities !");
      return "";
    }

    console.log(checkedFields);
    var finalString = "";

    switch(strignType){
      case "nameString":
        checkedFields.forEach(checkes=>{
          finalString+=checkes.value+", "
        })
        finalString = finalString.slice(0, -2)
        break;
      case "idString":
        checkedFields.forEach(checkes=>{
          finalString+=checkes.dataset.comid+","
        })
        finalString = finalString.slice(0, -1)
        break;
    }

    

    return finalString;
  }

  this.mainSetup()
}
// End Manage Commodity


// Manage Fields Verifivations
function ManageVerifications(){

  this.verificationData = [
    {
      fieldName:"contact",
      isVerified:false,
      vrfnErrorMsg:"Contact Number is not verified !"
    },
    {
      fieldName:"email",
      isVerified:false,
        vrfnErrorMsg:"Email ID is not verified !"
    },
    {
      fieldName:"gstin_no",
      isVerified:false,
      vrfnErrorMsg:"GSTIN No. is not verified !"
    },
    {
      fieldName:"pancard",
      isVerified:false,
        vrfnErrorMsg:"PAN CARD No is not verified !"
    },
    {
      fieldName:"ifsc",
      isVerified:false,
      vrfnErrorMsg:"IFSC Code is not verified !"
    }
  ]

  this.fieldInputs = $(".verfcn-input-wrapper input")

  this.mainSetup = () =>{
    this.fieldInputs.change(this.setNotVerified);

    $("#verify-phone").click(this.verifyPhone)
    $("#verify-usremail").click(this.verifyUsremail)
    $("#verify-gstinno").click(this.verifyGstinno)
    $("#verify-pancard").click(this.verifyPancard)
    $("#verify-ifsc").click(this.verifyIfsc)
  }


  this.verifyPhone = (btnEvent) =>{
    const  [btn,input,msgWrapper] = this.getUsefullElements(btnEvent.target);
    if(input.val().length == 0){
      this.showMessage(false,msgWrapper)
    }else{
      this.showMessage(true,msgWrapper)
    }
  
  }

  this.verifyUsremail = (btnEvent) =>{
    const  [btn,input,msgWrapper] = this.getUsefullElements(btnEvent.target);
    if(input.val().length == 0){
      this.showMessage(false,msgWrapper)
    }else{
      this.showMessage(true,msgWrapper)
    }
  }

  this.verifyGstinno = (btnEvent) =>{
    const  [btn,input,msgWrapper] = this.getUsefullElements(btnEvent.target);
    if(input.val().length == 0){
      this.showMessage(false,msgWrapper)
    }else{
      this.showMessage(true,msgWrapper)
    }
  }

  this.verifyPancard = (btnEvent) =>{
    const  [btn,input,msgWrapper] = this.getUsefullElements(btnEvent.target);
    if(input.val().length == 0){
      this.showMessage(false,msgWrapper)
    }else{
      this.showMessage(true,msgWrapper)
    }
  }

  this.verifyIfsc = (btnEvent) =>{
    const  [btn,input,msgWrapper] = this.getUsefullElements(btnEvent.target);
    if(input.val().length == 0){
      this.showMessage(false,msgWrapper)
    }else{
      this.showMessage(true,msgWrapper)
    }    
  }

  // Set Field to not verified
  this.setNotVerified = (event) =>{
      var input = event.target;
      if(input.value) {
        this.showMessage(false,$(input.closest('.verfcn-input-wrapper')).find('.verification-msg'));
      }
  }

  this.showMessage = (verified,verificationMsg) =>{
    if(verified) {
      verificationMsg.html(`<span class="text-success"><strong>Verified !</strong></span>`)
    }
    else {
      verificationMsg.html(`<span class="text-danger"><strong>Not Verified !</strong></span>`)
    };
    verificationMsg.fadeIn()
  }

  this.getUsefullElements = (target) =>{
     return [
        target,
        $(target.closest('.verfcn-input-wrapper')).find('input'),
        $(target.closest('.verfcn-input-wrapper')).find('.verification-msg')
     ]
  }

  this.mainSetup()
}

// Manage Load Added Documents 
function AddedDocsRender(){

  this.allDocss = [
    {
        docName:"Uploaded Firm Registration Doc:",
        id:"firm.doc"
    },
    {
        docName:"Uploaded Govt. approved indentity Documents:",
        id:"id.doc"
    },
    {
        docName:"Uploaded Bidder Authority Letter:",
        id:"auth.ltr.doc"
    },
    {
        docName:"Uploaded Address Proofs:",
        id:"addr.doc"
    },
    {
        docName:"Uploaded GST Np. Proof:",
        id:"gst.doc"
    },
    {
        docName:"Uploaded Pancard:",
        id:"pancard.doc"
    },
    {
        docName:"Uploaded Form 27 C Documents:",
        id:"f27c.doc"
    },
    {
        docName:"Uploaded Scanned Cancel Cheque:",
        id:"cancel.cheque.doc"
    },
  ];

  this.mainSetup = () => $('input[type="file"]').change(this.rndrAddedDocuments);

  this.rndrAddedDocuments = () =>{
    $("#uploaded-documents-wrapper").empty();

    var allFileInputs   = $('input[type="file"]').toArray();
    var docUpldedInputs = allFileInputs.filter(fileinput => fileinput.files.length != 0); 

    docUpldedInputs.forEach(input=>{
        var docInfo = this.allDocss.find(docs=>docs.id===input.name);
        $("#uploaded-documents-wrapper").append($(` 
          <div class="col-4">
            <span class="doc-label">${docInfo.docName}</span>
            <span class="btn btn-outline-primary" onclick="renderDocument('${docInfo.id}')">
              View Document
              <i class="fa-solid fa-folder-open"></i>
            </span>
          </div>
        `))
    })

  }
  
  this.mainSetup()
}

function renderDocument(inputName){
  var input   = $('input[type="file"]').toArray().find(impt=>impt.name === inputName);
  if(!input) return;
  const file = input.files[0];
  if (file) {
      if (file.type.startsWith('image/')) {
        const reader = new FileReader();
            reader.onload = function(e) {
                const img = new Image();
                img.src   = e.target.result;
                opneNewWindow(img)
            };
        reader.readAsDataURL(file);    
      }
      else if (file.type === 'application/pdf') {
        // If it's a PDF file
        const fileReader = new FileReader();
        fileReader.onload = function(e) {
              
        const pdfData = new Uint8Array(e.target.result);
        const loadingTask = pdfjsLib.getDocument({ data: pdfData });
        
        loadingTask.promise
        .then(function(pdf) {
            return pdf.getPage(1);
        })
        .then(function(page) {
                const canvas = document.createElement('canvas');
                const context = canvas.getContext('2d');
        
                const viewport = page.getViewport({ scale: 1.5 });
        
                canvas.width = viewport.width;
                canvas.height = viewport.height;
        
                const renderContext = {
                    canvasContext: context,
                    viewport: viewport,
                };
        
                page.render(renderContext).promise.then(function() {
                    opneNewWindow(canvas)
                });
            });
        };
                
        fileReader.readAsArrayBuffer(file);
      }
      else {
        alert('Invalid file type. Please select an image, PDF, or DOCX file.');
        fileInput.value = ''; // Clear the file input field
        previewContainer.innerHTML = '';
      }
  }
  function opneNewWindow(fileElement){
        console.log("opneNewWindow");
        var myWindow = window.open("", "MsgWindow", "width=800,height=600");
        if(myWindow.document.querySelector('body')){
            myWindow.document.querySelector('body').append(fileElement)
        }
  }
}

// End Manage Added Documents 