function removeEmptySubs(node) {
    if (node.subs) {
      if (node.subs.length === 0) {
        delete node.subs;
      } else {
        node.subs.unshift({ title: node.title, id: node.id });
        delete node.id;
        node.subs.forEach(removeEmptySubs);
      }
    }
  }
  
  function treeData(offices) {
    const officeMap = new Map();
    const rootOffices = [];
  
    offices.forEach((office) => {
      const { OFCID, OFC_NM, UND_OFCID } = office;
      const node = {
        id: OFCID,
        title: OFC_NM,
        subs: [],
      };
  
      if (officeMap.has(OFCID)) {
        node.subs = officeMap.get(OFCID).subs;
      }
  
      officeMap.set(OFCID, node);
  
      if (UND_OFCID === 0) {
        rootOffices.push(node);
      } else {
        if (officeMap.has(UND_OFCID)) {
          officeMap.get(UND_OFCID).subs.push(node);
        }
      }
    });
  
    rootOffices.forEach(removeEmptySubs);
  
    return rootOffices;
  }