function ElAppend(parentEl,...elements){
    this.parentEl = parentEl;
    this.element = elements;

    this.element.forEach((element)=> this.parentEl.append(element) );
}

// elementInfo = {};
// accessKey:'element Name'
function ElCreatore(elementsInfo){
    this.createdElements = {};
    this.elsInfo = elementsInfo;

    this.elementCreatore = () => {
        for(var elInfo in this.elsInfo) this.createdElements[elInfo] = document.createElement(this.elsInfo[elInfo])
    }
        
        
    

    this.elementCreatore();
    return this.createdElements;
}

// Tab Navigation
function TabNavigation(btnSection,clickElements='button',pageWrapper,pageClass) { 
    this.btnSection     = document.querySelector(btnSection);
    this.clickElements  = Array.from(this.btnSection.querySelectorAll(clickElements));
    this.pagesWrapper   = document.querySelector(pageWrapper);
    this.pages          = Array.from(this.pagesWrapper.querySelectorAll(pageClass))

    this.mainSetup = () =>{
        this.hideAllPages();
        this.manageActive();
        this.clickElements.forEach(el=>{
            el.addEventListener('click',()=>{
                var page = this.pages.find( page => page.dataset.page === el.dataset.page)
                this.hideAllPages();
                FadeIn(page)
            })
        })
    }

    this.manageActive = () =>{
        var activeBtn = this.clickElements.find(el=> el.dataset.active === 'true' );
        var activePage= this.pages.find(page=> page.dataset.page === activeBtn.dataset.page);
            this.hideAllPages();
            FadeIn(activePage);
    }

    this.hideAllPages = () => FadeOut(...this.pages) 

    this.mainSetup();
}

function formdataToObject(formData,removeEmtyKey = false){
    let object = {};

    for(let key of formData.keys()){
        object[key] = formData.get(key)
    }

    if(removeEmtyKey){
        for(let emptyKey in object){
            if( 
                object[emptyKey] === '' ||
                object[emptyKey] === 'none' ||
                typeof object[emptyKey] === 'object'){
                    delete object[emptyKey]
            }
        }
    }

    console.log(object);

    return object;
}


function RenderTimeInput (){
    
    this.inputWrapper = document.querySelectorAll('.need-time');

    this.inputData = {
        hours:['01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23','00'],
        mintsAdnSecs:['01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59','00'],
    }
    this.mainRow;

    this.hours = '<select  style="width:60px !important;" class="hh" name="hh" required><option value="" selected>HH</option>'
    this.minutes = '<select style="width:60px !important;"  class="mm" name="mm" required><option value="" selected>MM</option>';
    this.seconds = '<select style="width:60px !important;"  class="ss" name="ss" required><option value="" selected>SS</option>';

    this.inputData.hours.forEach(hour=>{
        this.hours+=`<option value='${hour}'>${hour}</option>`;
    });
    this.inputData.mintsAdnSecs.forEach(mintsSecs=>{
        this.minutes+=`<option value='${mintsSecs}'>${mintsSecs}</option>`;
        this.seconds+=`<option value='${mintsSecs}'>${mintsSecs}</option>`;
    });

    this.hours   +=  '</select>';
    this.minutes +=  '</select>';
    this.seconds +=  '</select>';

    this.mainRow = `<div class="row">
                        <div class="col-4">${this.hours}</div>
                        <div class="col-4">${this.minutes}</div>
                        <div class="col-4">${this.seconds}</div>
                    </div>`

    this.inputWrapper.forEach(wrapper=>{
        wrapper.innerHTML = this.mainRow;
    })
}