functionInitializer(
    renederScreens,
    renderUserInfo,
);

const navEls = elementAccessor(
    '#sideNav',
);

async function renederScreens(){
    navEls.sideNav.innerHTML = '';
    let screenData = await sendHttpRequest('getapps',new FormData());
    let menuHeading = document.createElement('li');
        menuHeading.className = 'app-sidebar__heading';
        menuHeading.textContent = 'Client Management';
        navEls.sideNav.append(menuHeading);

        
        screenData.Record.push({
            text:"Office",
            value:"office",
            icon:"map-marker"
        },
        {
            text:"Designation",
            value:"designation",
            icon:"exapnd2"
        })
        

        screenData.Record.forEach(navItem => {
            let list = document.createElement('li');

            let anchor = document.createElement('a');
                anchor.href = `#${navItem.value}`;

                if(navItem.value === "dashboard"){
                    anchor.classList.add('mm-active');
                }

            let linkIcon = document.createElement('i');
                linkIcon.className = "metismenu-icon pe-7s-"+navItem.icon;

            
            anchor.append(linkIcon)
            anchor.append(navItem.text)
            list.append(anchor)
            navEls.sideNav.append(list);
    
        });

    
    navEls.sideNav.addEventListener('click',event=>{
        navEls.sideNav.querySelectorAll('a').forEach(a=>{
            a.classList.remove('mm-active')
        })
        pageLoader(event.target.closest('a').hash);
        event.target.closest('a').classList.add('mm-active')
        
    });


}
 
function renderUserInfo (){
    document.getElementById('userName').textContent = localStorage.getItem("userName");
    document.getElementById('userRole').textContent = localStorage.getItem("role");
}

async function logOut(){
   const logout =  new FormData();
   logout.append('act','logout')
   localStorage.clear();
   location.reload()
   await sendHttpRequest('logout',logout);
}

if(localStorage.length !== 0){
    $("#app").empty();
    $("#app").load(`src/app/${(localStorage.getItem('role').toLowerCase())}/welcome.html`);
}

pageLoader("#setting")