
function  functionInitializer  (...funcions){
    $(document).ready(()=>{
        funcions.forEach(fn=>{
            fn();
        })
    })
}

function  elementAccessor  (...ids){
    let accessElements = {};
    ids.forEach(elId=>{
      let elementId = elId;
      accessElements[elementId.substring(1)] = document.querySelector(elId);
    })

    return accessElements;
};

function  pageLoader  (pageHash) {
    $("#app").empty();
    let loadUrl =`src/app/${(localStorage.getItem('role').toLowerCase())}/${pageHash.substring(1)}.html`;
    $("#app").load(loadUrl);
}

function getOption(text,value) { 
    return `<option value="${value}">${text}</option>`;
}

function Toaster(type,infoTitle,info){

    let toaster = `
    <div id="toast-container" class="toast-top-right">
        <div class="toast toast-${type}" aria-live='polite'>
            <button type="button" class="toast-close-button" role='button'>X</button>
            <div class="toast-title">
                ${infoTitle}
            </div>
            <div class="toast-title">
                ${info}
            </div>
        </div>
    </div>`;

    $("body").append(toaster);
    $('.toast-close-button').click(()=>{
        $("#toast-container").remove();
    })
    setTimeout(()=>{
        $("#toast-container").remove();
    },3000)
}

function tabNavigation(nav = 'tab-navigation'){
  let navigation = "#"+nav+" button";
  let allNavs = Array.from($(navigation));
  let firtBtn = $(navigation)[0];

  firtBtn.disabled = true;
  
  allNavs.forEach((el)=>{
      if(el.dataset.link !== firtBtn.dataset.link){
          $("#"+el.dataset.link).hide();
      }
  })

  $(navigation).click(

      function(){
          let elements = $(this).siblings();
          $(this)[0].disabled = true;
         
          $("#"+$(this)[0].dataset.link).show();

          for(let el of elements){
              el.disabled =false;
              $("#"+el.dataset.link).hide();
          };
       
      }

  )

}

async function readFile(fileObj){
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
          reader.readAsDataURL(fileObj);
            reader.onload = () => {
            resolve(reader.result);
          // need to run CD since file load runs outside of zone
          // this.cd.markForCheck();
        };
    });	
};

async function onSelectFile(event, formAttribute, isMultiple, maxSize, callBkfn){  		
    if (event.target.files && event.target.files.length) {
      const files = event.target.files;
      const uploadedFiles = [];
      
      for (let indx = 0; indx < files.length; indx++) {
        const fileObj = files[indx];
        
        if(maxSize && fileObj.size > maxSize) {
               alert('Image size is greater than allowed size.');
               return;  	        	
        }
        else if (fileObj.size > 1000000) {
          alert('Image size is greater than 1 MB');
          return;
      }
        // console.log(indx, uploadedFiles);
          uploadedFiles.push(await readFile(fileObj));
          if (isMultiple) {
          if (files.length - 1 === indx) {
              callBkfn(formAttribute, uploadedFiles);
             }
        } 
      else {	        	
          callBkfn(formAttribute, uploadedFiles);
        }     	        
      }      	      	
  }
}

function valueSetter(data){
    for(let elValue in data){
        $("."+elValue).val(data[elValue]);

    }
    
}

function containsWhitespace(str) {
    return /\s/.test(str);
}

function formDataToJson(formData){
    let formdata = {};
    for(key of formData.keys()){
        formdata[key] = formData.get(key);
    }

    return formdata;
}

function searchableSelect(config = {container:'',rawData:[],textAndId:['',''],infoFillers:['','']},clbkfn){
    var opts ='<option value="0">Please Select</option>';

    if(config.rawData){
        config.rawData.forEach((data)=>{
            opts +=getOption(data[config.textAndId[0]],data[config.textAndId[1]]);
        });
    }

    $(config.container).empty();

    $(config.container).html(`<select  style="width: 100%;">${opts}</select>`);

    $(config.container+" select").select2();

    $(config.container+" select").on('select2:select', (event)=> {
        var text = event.params.data.text;
        var id   = event.params.data.id;
        this.selectedData = config.rawData.find(data=> data.CLNT_ID ==event.params.data.id);
        if(config.infoFillers[0]) $(config.infoFillers[0]).val(text === 'Please Select' ? '':text)
        if(config.infoFillers[1]) $(config.infoFillers[1]).val(id)
        if(clbkfn) clbkfn(this.selectedData);
    });

}

function RenderOptions (){
    
    this.getOffices = async(selector) =>{
        var reqData = new FormData();
        reqData.append('act','srch');
        this.officesdata = await sendHttpRequest('managecommonoffice',reqData);
        if(selector)
        document.querySelectorAll(selector).forEach(element => {
            element.innerHTML = getOptions(this.officesdata.Records,'OFC_NM','OFCID',"Main Office","0");
        });
        
        return this.officesdata.Records
    }

}
const renderOptions = new RenderOptions(); 

/* Modal */
/**
Basic Modal = <div id="view-list-popup"><div><div class="header">heading<div class="hr"></div></div><div class="content-wrapper"><div class="table-wrapper"></div></div></div>div>
config:{};
    properties:
    selector:# or . or Tagname
    wrapperCss:"width:100%;background-color:red;"
    closeBtn:(false,default true),
    onclose:calback function
*/
function Modal(config) { 

    this.mainSetup = () =>{
        this.configration = config;
        this.modal = document.querySelector(this.configration.selector);
        this.modal.classList.add('app-modal');
        this.modal.style.display = 'none';

        this.basicSetup();
        this.manageModelElLocation();
        this.manageCloseModal();
    }

    this.basicSetup = () =>{
        this.modalWrapper = this.modal.querySelector('div');
        this.modalWrapper.classList.add('app-modal-wrapper');

        if(this.configration.boxShadow !== false) this.modalWrapper.classList.add('modal-wrapper-shadow')

        this.modalWrapper.setAttribute('style',this.configration.wrapperCss);

        $(this.modalWrapper).draggable()
    }

    // Setting Last In The Body Element
    this.manageModelElLocation = ( ) => document.body.append(this.modal);

    // Manage Close Modal
    this.manageCloseModal = () =>{
        this.closeBtns = this.modal.querySelectorAll('.close-popup');
        this.closeBtnMain = document.createElement('div');
        this.closeBtnMain.classList.add('main-close-btn');

        this.closeBtnMain.innerHTML = '<i class="fa-solid fa-circle-xmark"></i>';

        this.closeBtnMain.addEventListener('click',()=>{
            this.hideModal()
            if(this.configration.onclose)this.configration.onclose();
        });
        
        this.closeBtns.forEach(btn => {
            btn.addEventListener('click',()=>{
                this.hideModal();
                if(this.configration.onclose)this.configration.onclose();
            });
            
        });

        if(this.configration.closeBtnMain !== false) {
            this.modalWrapper.append(this.closeBtnMain);
        };
    }

    // Manage Show And Hide
    this.showModal = () => FadeIn(this.modal);
    this.hideModal = () => FadeOut(this.modal);

    this.mainSetup();
}

function getOptions(optionData,textKey,valueKey,defaultText,defaultValue){
    let options =  defaultText!== undefined && defaultValue !== undefined ? `<option value="${defaultValue}">${defaultText}</option>` : `<option value="">Please Select</option>`;

    optionData.forEach((data)=> options += `<option value="${data[valueKey]}">${data[textKey]}</option>`);

    return options;
}

function FadeIn(...elements){
    elements.forEach(element => {
        $(element).fadeIn();
    });
}

function FadeOut(...elements){
    elements.forEach(element => {
        $(element).fadeOut();
    });
}

function formdataToObject(formData,removeEmtyKey = false){
    let object = {};

    for(let key of formData.keys()){
        object[key] = formData.get(key)
    }

    if(removeEmtyKey){
        for(let emptyKey in object){
            if( 
                object[emptyKey] === '' ||
                object[emptyKey] === 'none' ||
                typeof object[emptyKey] === 'object'){
                    delete object[emptyKey]
            }
        }
    }

    console.log(object);

    return object;
}

function checkIfFromValid(formSelector,customError){
    var formValidity = false;
    if($(formSelector)[0].checkValidity() === false){
        formValidity = false;
        if(customError){
            alert(customError)
        }else{
            alert("Please fill required fields !")
        }
        $(formSelector).addClass('was-validated');
    }else{
        formValidity = true;
    }
    return formValidity;
}