
const appLoader = document.getElementById('loader');

const valResponse = (response)=>{
    if(response.Msg){
        if(response.Result=="SESS"){	        		
            Toaster('error','Session Expired !',response.Msg);
            sessionExipre()
            // localStorage.clear();
            // location.replace('login.html')
            return;
        }else if(response.Result === 'OK'){
            Toaster('success','',response.Msg)
        }else if(response.Result === 'NOK'){
            Toaster('error','Erro',response.Msg)
        }else{
            Toaster('error','',response.error)
        }
    }
}

function sendHttpRequest(url,data) { 
    return new Promise(resolve=>{
        appLoader.style.display = 'flex';
        let reqData = data;
        reqData.delete('token');
        reqData.append('token',localStorage.getItem('token'));
        $.ajax({
            type: "POST",
            url: host+url,
            data: reqData,
            processData: false,
            contentType:false,
            timeout: 600000,
            success: function (response) {
                if(reqData.get('act') !== 'getall' && reqData.get('act') !== 'getall'){
                    valResponse(response)
                }
                appLoader.style.display = 'none';
                resolve(response)
            },
            error: function(response){
                valResponse(response)
                resolve(response)
                appLoader.style.display = 'none';
            }
        });
    })
}

function sendMultipartRequest(url,data){
    return new Promise(resolve=>{
        appLoader.style.display = 'flex';
        let reqData = data;
        reqData.append('token',localStorage.getItem('token'));
        $.ajax({
            type: "POST",
            enctype: 'multipart/form-data',
            url: host+url,
            data: reqData,
            processData: false,
            contentType:false,
            // cache: false,
            timeout: 600000,
            success: function (response) {
                valResponse(response)
                appLoader.style.display = 'none';
                resolve(response)
            },
            error: function(response){
                valResponse(response)
                resolve(response)
                appLoader.style.display = 'none';
            }
        });
    })
}

const formDataManager = (formel) => {

    let form = new FormData(formel);
        let formdata = {};
        for(let key of form.keys()){
        formdata[key] = form.get(key);
    }

    return formdata;
}

const addFormValidations = (formId,callbkFn) =>{
    let form = $("#"+formId);
    $(form).off( "submit" );

    $(form).submit(function(event){

    	if(form[0].checkValidity() === true) {
        	callbkFn();
    	}

    	event.preventDefault();
      	event.stopPropagation();
        form[0].classList.add('was-validated');
    });
}

function sessionExipre(){
    $(".app-container").hide();
    $(".session-expired").show();
}