function generateRandom5DigitNumber () {
    const min = 1; // Minimum 5-digit number (inclusive)
    const max = 999999; // Maximum 5-digit number (inclusive)
    return Math.floor(Math.random() * (max - min + 1)) + min;
}


function removeEmptySubs(node) {
    if (node.subs) {
      if (node.subs.length === 0) {
        delete node.subs;
      } else {
        // node.subs.unshift({ title: node.title, id: node.id });
        // delete node.id;
        node.subs.forEach(removeEmptySubs);
      }
    }
}
  
function treeData(offices) {
    const officeMap = new Map();
    const rootOffices = [];
  
    offices.forEach((office) => {
      const { OFCID, OFC_NM, UND_OFCID } = office;
      const node = {
        id: OFCID,
        title: OFC_NM,
        subs: [],
      };
  
      if (officeMap.has(OFCID)) {
        node.subs = officeMap.get(OFCID).subs;
      }
  
      officeMap.set(OFCID, node);
  
      if (UND_OFCID === 0) {
        rootOffices.push(node);
      } else {
        if (officeMap.has(UND_OFCID)) {
          officeMap.get(UND_OFCID).subs.push(node);
        }
      }
    });
  
    rootOffices.forEach(removeEmptySubs);
  
    return rootOffices;
}

function formInitialState(FormSelectore,onStatChange){
            
    this.formSelectore      = FormSelectore;
    this.onStatChange       = onStatChange;

    this.initialStateObject = [];

    this.mainSetup = () =>{
        this.valueSnapshotHandler("setIntialValuesState")
    }

    // Set Initial Values map
    // Get snapshot of changes values
    // @Param act = "getSnapshot" || "setIntialValuesState" 
    this.valueSnapshotHandler = (act) =>{

        var all_input_checks_radios_select = $(this.formSelectore).find("input , select, textarea").toArray()

            var valuesObject = [];

            all_input_checks_radios_select.forEach((input,index)=>{
      
                var inputInfo = {inputIndex:index};

                if(input.tagName === 'INPUT'){
                    if(input.type === 'checkbox' || input.type === 'radio'){
                        inputInfo.value = input.checked;
                    }else inputInfo.value = input.value;
                    
                }else{
                    inputInfo.value = input.value;
                }

                if(this.onStatChange != undefined){
                    // $(input).on('input' ,this.changeInputState);
                    // $(input).on('change',this.changeInputState);
                    $(input).on('focus' ,this.changeInputState);
                    $(input).on('blur'  ,this.changeInputState);
                }

                valuesObject.push(inputInfo)
            });
            
            switch(act){
                case "getSnapshot": 
                    return valuesObject;
                    break;
                case "setIntialValuesState": 
                    this.initialStateObject = JSON.parse(JSON.stringify(valuesObject));
                    valuesObject = [];
                    break;
            }  

    }

    this.changeInputState = () =>{
        this.onStatChange(this.getFormIntialState())
    }

    this.getFormIntialState = () =>{
        console.log(this.initialStateObject);
        var snapshot = this.valueSnapshotHandler("getSnapshot");
        console.log(snapshot);
        for (let i = 0; i < this.initialStateObject.length; i++) {
            var initial = this.initialStateObject[i];
            var current = snapshot[i];
            if(initial.value !=  current.value){
                return true;
            }
        }

        return false;
    }

    this.mainSetup()
}

function MngDtlsByOfcHrchy(officeData){

    this.officeData  = officeData;
    this.setFirstClassToUl = false;

    this.renderOffices = (parentList,InputHtml) =>{
        this.parentList = parentList;
        this.renderListAsArray(this.officeData,this.parentList,InputHtml);

        // Added Save Btns
        // $(this.parentList).append($(`
        //     <div class="text-center save-btn-wrapper">
        //         <button class="btn btn-success btn-lg">Save</button>
        //     </div>
        // `));
        // $(this.parentList).find(".save-btn-wrapper button").click(this.onSave)

    }

    this.renderListAsArray = (officeData,parentList,InputHtml) =>{
        const list = document.createElement('ol');
        if(!this.setFirstClassToUl){
            parentList.classList.add("office-heiranchy-list");
            this.setFirstClassToUl = true;  
        }
        parentList.appendChild(list);

        officeData.forEach(item => {
            const listItem = document.createElement('li');
            listItem.classList.add('collapsed-list');

            listItem.dataset.officeId = item.id

            var ItemHtml = `
                <div class="input-wrapper">
                    <div class="row" style="width:100%;">
                        <div class="col-2 office-name">${item.title}</div>
                        <div class="col-9">
                            ${InputHtml}
                        </div>
                        <div class="col-1">
                            <button class="btn btn-outline-secondary btn-sm reset-btn">
                                <i class="fa-solid fa-rotate-right"></i>
                            </button>
                        </div>
                    </div>    
                </div>`;

            if (item.subs && item.subs.length > 0) {
                ItemHtml = `
                    <span class="office-collapser">
                        <span class="un-collapse-icon">
                            <i class="fa-solid fa-square-caret-right"></i>   
                        </span>
                        <span class="collapse-icon" style="display:none;">
                            <i class="fa-solid fa-square-caret-down"></i>
                        </span>
                    </span>`+ItemHtml;

                listItem.innerHTML = ItemHtml;
                listItem.dataset.hasSuboffice = 'yes';
                this.renderListAsArray(item.subs, listItem,InputHtml);
            }else{
                listItem.innerHTML = ItemHtml;
                $(listItem).find(".office-applicability-selectore").attr("style","display:none;");
                listItem.dataset.hasSuboffice = 'no';
            }

            list.appendChild(listItem);
            this.addListners(listItem)
        });
       
    }

    this.addListners = (listItem) => {
        
        var applicabilitySelectore = listItem.querySelector('.office-applicability-selectore');

        if(listItem.dataset.hasSuboffice === 'yes'){

            var unCollapseBtn          ;
            var collapseBtn            ;

           unCollapseBtn          = listItem.querySelector('.un-collapse-icon');
           collapseBtn            = listItem.querySelector('.collapse-icon');

           $(unCollapseBtn).click(event=> {
               if(applicabilitySelectore.value === 'S') return;

               event.target.closest('li').classList.remove('collapsed-list');
               unCollapseBtn.style.display = 'none';
               collapseBtn.style.display = 'block';
           })
           
           $(collapseBtn).click(event => {
               $(listItem).find('ol').find('.collapse-icon').click()
               event.target.closest('li').classList.add('collapsed-list');
               unCollapseBtn.style.display = 'block';
               collapseBtn.style.display = 'none';
           })
           
            applicabilitySelectore.addEventListener("change",()=>{
                switch(applicabilitySelectore.value){
                        case "S":
                            collapseBtn.click();
                            $(listItem).find('ol .valid-info').removeClass('valid-info')
                            $(listItem).find('ol .reset-btn').click()
                            break;
                        case "D":
                                $(unCollapseBtn).click()
                            break;
                }     
            });
        }else{
            applicabilitySelectore.value = "D"
        }
        
        $(listItem).find(".reset-btn").click((event)=>{
            var form = event.target.closest('.input-wrapper').querySelector('form');
                form.className = '';
                form.reset()
        });

        var form = listItem.querySelector('form');
        var formState = new formInitialState(form);

        $(form).find('input,select').on('input',formInputListner);
        $(form).find('input,select').on('change',formInputListner);
        $(form).find('input,select').on('focus',formInputListner);
        $(form).find('input,select').on('blur',formInputListner);

        function formInputListner(event){

            if(event.type ==='focus'){
                form.className = 'was-validated form-touched';
                return;
            }

            if(formState.getFormIntialState()) form.className = 'was-validated form-touched'
            else form.className = '';

            if(form.checkValidity()){
                form.classList.remove("was-validated");
                $(listItem).find('.input-wrapper')[0].classList.add("valid-info");
            }
            else{
                $(listItem).find('.input-wrapper')[0].classList.remove("valid-info")
            }

        }
    }   

    // this.onSave = () =>{
    //     var infoRows = $(this.parentList).find(".valid-info");
    //     if(infoRows.length == 0 ){
    //         alert("No Information Added !")
    //         return ;
    //     }
    // }

    this.getValidInfos = () => $(this.parentList).find(".valid-info");
        
    this.getUnderOfficeIds = (data,mainOfficeId) =>{
        
        for (const item of data) {

            if (item.id === mainOfficeId) {
                return item;
            }

            if (item.subs && item.subs.length > 0) {
              const foundItem = this.getUnderOfficeIds(item.subs, mainOfficeId);
              if (foundItem) {
                return foundItem;
              }
            }
        }

    }

    this.getUndrIdArray = (mainOfficeId) =>{
        console.log(mainOfficeId);
        var officeIds = '';

        var offices = this.getUnderOfficeIds(this.officeData,mainOfficeId);

        function arrangeIds(ofcs){
            ofcs.forEach((item)=>{
                officeIds += item.id+",";
                if(item){
                    if(item.subs){
                        item.subs.forEach((subs)=>{
                            officeIds += subs.id+",";
                        })
                    }
                }
            });
        }

        arrangeIds(offices.subs);

        officeIds = `[${officeIds.slice(0, -1)}]`;

        return  JSON.parse(officeIds) ;
    }

}


var rawOfficeData = [
            {
            "OFC_CODE": "0.",
            "UND_OFCID": 0,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Main Office",
            "OFC_DETAIL": "Pune Office",
            "OFC_NM": "Pune",
            "OFCID": 1
            },
            {
            "OFC_CODE": "0.",
            "UND_OFCID": 0,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "",
            "OFC_DETAIL": "Nagpur Office",
            "OFC_NM": "Nagpur",
            "OFCID": 2
            },
            {
            "OFC_CODE": "0.",
            "UND_OFCID": 0,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "",
            "OFC_DETAIL": "Gondia Office",
            "OFC_NM": "Gondia",
            "OFCID": 3
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Bhandara Office",
            "OFC_NM": "Bhandara",
            "OFCID": 4
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Aamgao Office\r\n",
            "OFC_NM": "Aamgao",
            "OFCID": 5
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Vidarbh Office",
            "OFC_NM": "Vidarbh",
            "OFCID": 6
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Gadchiroli",
            "OFC_NM": "Gadchiroli",
            "OFCID": 7
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Wardha",
            "OFC_NM": "Wardha",
            "OFCID": 8
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Dhule",
            "OFC_NM": "Dhule",
            "OFCID": 9
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Jalgaon",
            "OFC_NM": "Jalgaon",
            "OFCID": 10
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Vidarbh",
            "OFC_NM": "Vidarbha",
            "OFCID": 11
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Nandurbar",
            "OFC_NM": "Nandurbar",
            "OFCID": 12
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Nashik",
            "OFC_NM": "Nashik",
            "OFCID": 13
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Ahmednagar",
            "OFC_NM": "Ahmednagar",
            "OFCID": 14
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Mumbai City District",
            "OFC_NM": "Mumbai City District",
            "OFCID": 15
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "Mumbai Suburban District",
            "OFC_NM": "Mumbai Suburban District",
            "OFCID": 16
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Thane",
            "OFC_NM": "Thane",
            "OFCID": 17
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Satara",
            "OFC_NM": "Sangli",
            "OFCID": 18
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Satara",
            "OFC_NM": "Satara",
            "OFCID": 19
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Satara",
            "OFC_NM": "Satara",
            "OFCID": 20
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Solapur",
            "OFC_NM": "Solapur",
            "OFCID": 21
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Kolhapur",
            "OFC_NM": "Kolhapur",
            "OFCID": 22
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Akola",
            "OFC_NM": "Akola",
            "OFCID": 23
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Amravati",
            "OFC_NM": "Amravati",
            "OFCID": 24
            },
            {
            "OFC_CODE": "0.2.",
            "UND_OFCID": 2,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Nagpur",
            "OFC_DETAIL": "Buldhana",
            "OFC_NM": "Buldhana",
            "OFCID": 25
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Yavatmal",
            "OFC_NM": "Yavatmal",
            "OFCID": 26
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Washim",
            "OFC_NM": "Washim",
            "OFCID": 27
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Aurangabad",
            "OFC_NM": "Aurangabad",
            "OFCID": 28
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Beed",
            "OFC_NM": "Beed",
            "OFCID": 29
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Jalna",
            "OFC_NM": "Jalna",
            "OFCID": 30
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Osmanabad",
            "OFC_NM": "Osmanabad",
            "OFCID": 31
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Nanded",
            "OFC_NM": "Nanded",
            "OFCID": 32
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Latur",
            "OFC_NM": "Latur",
            "OFCID": 33
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Parbhani",
            "OFC_NM": "Parbhani",
            "OFCID": 34
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Hingoli",
            "OFC_NM": "Hingoli",
            "OFCID": 35
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "Chandrapur",
            "OFC_NM": "Chandrapur",
            "OFCID": 36
            },
            {
            "OFC_CODE": "0.1.4.",
            "UND_OFCID": 4,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Bhandara",
            "OFC_DETAIL": "Bhandara Sub Office",
            "OFC_NM": "Bhandara Sub Office",
            "OFCID": 37
            },
            {
            "OFC_CODE": "0.1.4.37.",
            "UND_OFCID": 37,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Bhandara Sub Office",
            "OFC_DETAIL": "Sub Office Off Sub Office",
            "OFC_NM": "Sub Office Off Sub Office",
            "OFCID": 38
            },
            {
            "OFC_CODE": "0.",
            "UND_OFCID": 0,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Main Office",
            "OFC_DETAIL": "New",
            "OFC_NM": "New Office",
            "OFCID": 39
            },
            {
            "OFC_CODE": "0.3.",
            "UND_OFCID": 3,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Gondia",
            "OFC_DETAIL": "New New Office",
            "OFC_NM": "New New Office",
            "OFCID": 40
            },
            {
            "OFC_CODE": "0.1.",
            "UND_OFCID": 1,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Pune",
            "OFC_DETAIL": "New New Office",
            "OFC_NM": "New New Office",
            "OFCID": 41
            },
            {
            "OFC_CODE": "0.1.4.37.38.",
            "UND_OFCID": 38,
            "STAT": "A",
            "OFC_LVL": 1,
            "UND_OFCNM": "Sub Office Off Sub Office",
            "OFC_DETAIL": "TEST",
            "OFC_NM": "Last Sub Office",
            "OFCID": 42
            }
]

var data = treeData(rawOfficeData)


// var data =  [
//     {   
//         id:1,
//         "title": "Pune",
//         "subs": [
//             {
//                 id:2,
//                 "title": "Bhandara",
//                 "subs": [
//                     {
//                         id:3,
//                         "title": "Bhandara Sub Office",
//                         "subs": [
//                             {
//                                 "title": "Sub Office Off Sub Office",
//                                 id:4,
//                                 "subs": [
//                                     {
//                                         "id": 42,
//                                         "title": "Last Sub Office"
//                                     }
//                                 ]
//                             }
//                         ]
//                     }
//                 ]
//             },
//             {
//                 "id": 5,
//                 "title": "Aamgao"
//             },
//             {
//                 "id": 6,
//                 "title": "Vidarbh"
//             },
//             {
//                 "id": 7,
//                 "title": "Gadchiroli"
//             },
//             {
//                 "id": 8,
//                 "title": "Wardha"
//             },
//             {
//                 "id": 9,
//                 "title": "Dhule"
//             },
//             {
//                 "id": 10,
//                 "title": "Jalgaon"
//             },
//             {
//                 "id": 11,
//                 "title": "Vidarbha"
//             },
//             {
//                 "id": 12,
//                 "title": "Nandurbar"
//             },
//             {
//                 "id": 13,
//                 "title": "Nashik"
//             },
//             {
//                 "id": 14,
//                 "title": "Ahmednagar"
//             },
//             {
//                 "id": 16,
//                 "title": "Mumbai Suburban District"
//             },
//             {
//                 "id": 41,
//                 "title": "New New Office"
//             }
//         ]
//     },
//     {   id:888,
//         "title": "Nagpur",
//         "subs": [
//             {
//                 "id": 15,
//                 "title": "Mumbai City District"
//             },
//             {
//                 "id": 17,
//                 "title": "Thane"
//             },
//             {
//                 "id": 18,
//                 "title": "Sangli"
//             },
//             {
//                 "id": 19,
//                 "title": "Satara"
//             },
//             {
//                 "id": 20,
//                 "title": "Satara"
//             },
//             {
//                 "id": 21,
//                 "title": "Solapur"
//             },
//             {
//                 "id": 22,
//                 "title": "Kolhapur"
//             },
//             {
//                 "id": 23,
//                 "title": "Akola"
//             },
//             {
//                 "id": 24,
//                 "title": "Amravati"
//             },
//             {
//                 "id": 25,
//                 "title": "Buldhana"
//             }
//         ]
//     },
//     {   id:999,
//         "title": "Gondia",
//         "subs": [
//             {
//                 "id": 26,
//                 "title": "Yavatmal"
//             },
//             {
//                 "id": 27,
//                 "title": "Washim"
//             },
//             {
//                 "id": 28,
//                 "title": "Aurangabad"
//             },
//             {
//                 "id": 29,
//                 "title": "Beed"
//             },
//             {
//                 "id": 30,
//                 "title": "Jalna"
//             },
//             {
//                 "id": 31,
//                 "title": "Osmanabad"
//             },
//             {
//                 "id": 32,
//                 "title": "Nanded"
//             },
//             {
//                 "id": 33,
//                 "title": "Latur"
//             },
//             {
//                 "id": 34,
//                 "title": "Parbhani"
//             },
//             {
//                 "id": 35,
//                 "title": "Hingoli"
//             },
//             {
//                 "id": 36,
//                 "title": "Chandrapur"
//             },
//             {
//                 "id": 40,
//                 "title": "New New Office"
//             }
//         ]
//     },
//     {
//         "id": 39,
//         "title": "New Office"
//     }
// ];